const TravelCategoryRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const travelCategory = require('../controller/travelCategory.controller');

module.exports = (app) => {
    TravelCategoryRouter.post('/', websiteImageUpload, travelCategory.create);

    // get all

    TravelCategoryRouter.get('/', travelCategory.getAll);

    // get active data

    TravelCategoryRouter.get('/active', travelCategory.getActiveData);

    // update

    TravelCategoryRouter.put('/:id', websiteImageUpload, travelCategory.update);

    // delete

    TravelCategoryRouter.delete('/:id', travelCategory.delete);

    app.use('/api/travelCategory', TravelCategoryRouter);
};
