const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const tourTypeModel = db.model.tourType;
const packageModel = db.model.package;

exports.create = async (req, res) => {
    try {
        const { name, success_count, description, status } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const tourTypeData = {
            name,
            image,
            success_count,
            description,
            status,
        };

        const result = await tourTypeModel.create(tourTypeData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Tour Type created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await tourTypeModel.findAll({
            include: [{
                model: packageModel, as: 'package',
            }]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await tourTypeModel.findOne({
            where: {
                id,
            },
            include: [{
                model: packageModel, as: 'package',
            }]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await tourTypeModel.findAll({
            where: {
                status: 1,
            },
            include: [{
                model: packageModel, as: 'package',
            }]
        });
        console.log("result", result)

        if (result.length === 0) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, success_count, description, status } = req.body;
        const { files } = req;

        console.log(req.body);

        const isExist = await tourTypeModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename ||
            isExist?.image;

        const tourTypeData = {
            name,
            image,
            success_count,
            description,
            status,
        };

        const result = await tourTypeModel.update(tourTypeData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Tour Type created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await tourTypeModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Tour Type deleted failed', res);
        }

        return successResponse(204, 'OK', 'Tour Type deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
