const subcsriptionRouter = require('express').Router();
const subcsriptionController = require('../controllers/subscription.controllers');
const { verifyUser, verifyToken } = require('../../../../middlewares/authJwt');

module.exports = (app) => {
    // get all user_subscriptions table data
    // subcsriptionRouter.get('/get-subs/:userId', subcsriptionController.fetchById);

    subcsriptionRouter.get('/', subcsriptionController.getAllSubs);
    // get all subs by users
    // subcsriptionRouter.get('/user/:id', subcsriptionController.getAllSubsByUser);

    subcsriptionRouter.get('/user', verifyToken, subcsriptionController.getAllSubsByUser);

    app.use('/api/subscriptions', subcsriptionRouter);
};
