require('dotenv').config();
// const { model } = require("mongoose");
const db = require('../../../../config/database.config');

const UserSubscription = db.model.userSubscription;
const Package = db.model.package;

const User = db.model.user;
const Role = db.model.role;

const { PackageCategory } = db.model;

const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

exports.fetchById = async (req, res) => {
    const { userId } = req.params;
    try {
        const subscription = await UserSubscription.findOne({
            where: {
                user_id: userId,
            },
            include: [
                {
                    model: Package,
                    as: 'package',
                },
            ],
        });
        if (subscription) {
            successResponse(201, 'OK', subscription, res);
        } else {
            successResponse(201, 'OK', subscription, res);
        }
    } catch (e) {
        errorResponse(
            501,
            'ERROR',
            e.message || 'Some error occurred while fetching subscription info',
            res
        );
    }
};

exports.getAllSubs = async (req, res) => {
    try {
        const allSubsUser = await UserSubscription.findAll({
            include: [
                {
                    model: User,
                    as: 'user_info',
                    attributes: ['image', 'registration_no', 'f_name', 'l_name', 'mobile', 'email'],
                    include: {
                        model: Role,
                        as: 'role',
                        attributes: ['name'],
                    },
                },
                {
                    model: Package,
                    as: 'package',
                    attributes: ['name'],
                    include: [
                        {
                            model: PackageCategory,
                            as: 'packageCat',
                            attributes: ['id', 'name'],
                        },
                    ],
                },
            ],
        });

        successResponse(201, 'SUCCESS', allSubsUser, res);
    } catch (error) {
        errorResponse(401, 'Error', error.message || 'Error while getting subscribed user', res);
    }
};

exports.getAllSubsByUser = async (req, res) => {
    try {
        const { user } = req;
        console.log(user);
        if (!user) {
            return errorResponse(401, 'Error', 'User not found', res);
        }
        const allSubs = await UserSubscription.findAll({
            where: {
                user_id: user.id,
            },
            include: [
                // {
                //     model: User,
                //     as: 'user_info',
                //     attributes: ['image', 'registration_no', 'f_name', 'l_name', 'mobile', 'email'],
                // },
                {
                    model: Package,
                    as: 'package',
                    // attributes: ['name', 'price'],
                    include: [
                        {
                            model: PackageCategory,
                            as: 'packageCat',
                            // attributes: ['id', 'name'],
                        },
                    ],
                },
            ],
        });

        return successResponse(201, 'OK', allSubs, res);
    } catch (error) {
        return errorResponse(
            401,
            'Error',
            error.message || 'Error while getting subscribed user',
            res
        );
    }
};
