const stripe = require('stripe')(process.env.STRIPE_SECRET_KEY);
const db = require('../../../../config/database.config');
const errorResponse = require('../../../../utils/errorResponse');
const { expiryDateCalculate } = require('../../../../utils/expirayDateCalculate');
const successResponse = require('../../../../utils/successResponse');

const redirectURL = `${process.env.REACT_APP_API_BASE_URL}/payment/stripe/payment-status`;

const PaymentModel = db.model.user_payment;
const PackageModel = db.model.package;
const UserSubscription = db.model.userSubscription;
const UserModel = db.model.user;

async function createPrice(packageData) {
    try {
        const price = await stripe.prices.create({
            currency: 'usd',
            unit_amount: Number(packageData.package_price) * 100,
            // product: packageData.package_id,
            // recurring: {
            //     interval: 'month',
            // },
            product_data: {
                name: packageData.package_name,
            },
        });
        return price;
    } catch (err) {
        console.log(err);
        throw new Error(err);
    }
}

async function storeBasicPaymentData(data) {
    try {
        const paymentData = {
            user_id: data?.user_id, // Pass the user ID from your application
            tran_date: new Date(),
            payment_user_name: `${data?.f_name} ${data?.l_name ?? ''}`,
            payment_user_email: data.email,
            total_amount: data?.package_price,
            currency: 'usd',
            payment_package_id: data?.package_id,
            card_type: 'stripe', // Since it's a PayPal payment
            card_brand: 'stripe', // Since it's a PayPal payment
            status: 0,
        };
        const results = await PaymentModel.create(paymentData);
        return results;
    } catch (err) {
        throw new Error(err);
    }
}

exports.createStripePaymentOrder = async (req, res) => {
    try {
        const { f_name, l_name, email, mobile, package_id, package_name, package_price } = req.body;
        console.log('req.body', req.body);
        const userData = await UserModel.findOne({ where: { mobile } });

        // if (!userData) {
        //     return errorResponse(404, 'FAILED', 'User not found', res);
        // }

        const createPriceRes = await createPrice({
            package_id,
            package_name,
            package_price,
        });
        console.log('createPriceRes', createPriceRes);

        const transformedItem = {
            // client_reference_id: mobile,
            // customer: {
            //     first_name: f_name,
            //     last_name: l_name,
            //     phone: mobile,
            // },
            // customer_email: email,
            // price_data: {
            //     currency: 'usd',
            //     product_name: package_name,
            //     unit_amount: package_price,
            // },
            price: createPriceRes.id,
            quantity: 1,
        };

        const paymentData = await storeBasicPaymentData(req.body);

        const session = await stripe.checkout.sessions.create({
            payment_method_types: ['card'],
            line_items: [transformedItem],
            mode: 'payment',
            success_url: `${redirectURL}?status=success&session_id={CHECKOUT_SESSION_ID}`,
            cancel_url: `${redirectURL}?status=cancel`,
            // return_url: 'http://localhost:4000/membership-package/payment/14',
            metadata: {
                payment_id: paymentData?.id,
                user_id: userData?.id,
                package_id: paymentData?.payment_package_id,
                first_name: f_name,
                last_name: l_name,
                phone: mobile,
            },
        });

        console.log('stripe session', session);
        return successResponse(200, 'OK', session, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while generate strie session id',
            res
        );
    }
};

async function updatePaymentData(result) {
    try {
        if (result.payment_status === 'paid') {
            const { customer_details, payment_intent, total_details, metadata } = result;

            const paymentData = {
                user_id: metadata.user_id,
                user_mobile: metadata.phone,
                tran_date: new Date(result.created * 1000), // Convert UNIX timestamp to Date object

                tran_id: payment_intent,
                account_id: null, // No specific PayPal account ID available in Stripe session
                payment_user_name: customer_details.name,
                payment_user_email: customer_details.email,
                payment_location: customer_details.address.country, // Assuming country is the location
                // total_amount: total_details.amount_total / 100, // Convert from cents to dollars
                payment_fee: 0, // No PayPal fee breakdown available in Stripe session
                store_amount: total_details.amount_total / 100, // Assuming full amount is received by store
                currency: result.currency.toUpperCase(),
                payment_package_id: metadata.package_id,
                card_type: 'stripe',
                card_brand: 'stripe',
                status: 1,
            };

            // Assuming PaymentModel is your model for storing payment data
            const results = await PaymentModel.update(paymentData, {
                where: {
                    id: metadata.payment_id,
                },
            });
            return results;
        }
        return null;
    } catch (err) {
        throw new Error(err);
    }
}

// save to subscription

async function storeSubscription({ user_id, package_id, payment_id }) {
    try {
        const packageData = PackageModel.findOne({ where: { id: package_id } });
        if (!packageData) {
            throw new Error('Package not found');
        }

        const subscriptionData = {
            user_id,
            subscription_type: 'membership Package',
            package_id,
            payment_id,
            purchase_date: new Date(),
            // expiry_date: expiryDateCalculate(packageData.duration),
            status: 1,
        };

        const result = await UserSubscription.create(subscriptionData);

        return result;
    } catch (err) {
        throw new Error(err);
    }
}

exports.paymentStatusCheckAndSave = async (req, res) => {
    try {
        const { status, session_id } = req.query;
        console.log('payment status', status, session_id);
        const session = await stripe.checkout.sessions.retrieve(session_id);
        console.log('Retrieved session from Stripe:', session);

        // Now retrieve the Payment Intent associated with the session
        const paymentIntentId = session.payment_intent;
        const paymentIntent = await stripe.paymentIntents.retrieve(paymentIntentId);

        await updatePaymentData(session);
        await storeSubscription(session.metadata);

        console.log('Retrieved payment intent from Stripe:', paymentIntent);
        return res.redirect('localhost:4000');
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while saving payment data',
            res
        );
    }
};

exports.createStripeDonationIntent = async (req, res) => {
    try {
        const { f_name, l_name, email, mobile, amount, campeign_id, package_id, payment_type } =
            req.body;
        console.log(req.body);
        const donation = await stripe.paymentIntents.create({
            amount,
            currency: 'usd',
            automatic_payment_methods: { enabled: true },
            metadata: {
                f_name,
                l_name,
                email,
                mobile,
                campeign_id,
                package_id,
                payment_type,
            },
        });
        // console.log(donation);
        return successResponse(200, 'OK', { clientSecret: donation.client_secret }, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while saving payment data',
            res
        );
    }
};
