const checkoutNodeJssdk = require('@paypal/checkout-server-sdk');
const fetch = require('node-fetch');

const clientId = process.env.PAYPAL_CLIENT_ID;
const clientSecret = process.env.PAYPAL_CLIENT_SECRET;

const base = 'https://api-m.sandbox.paypal.com';

const configureEnvironment = () =>
    // return process.env.NODE_ENV === 'production'
    //     ? new checkoutNodeJssdk.core.LiveEnvironment(clientId, clientSecret)
    //     : new checkoutNodeJssdk.core.SandboxEnvironment(clientId, clientSecret);
    new checkoutNodeJssdk.core.SandboxEnvironment(clientId, clientSecret);
exports.paypalClient = () => new checkoutNodeJssdk.core.PayPalHttpClient(configureEnvironment());

exports.generatePaypalAccessToken = async () => {
    try {
        if (!clientId || !clientSecret) {
            throw new Error('MISSING_API_CREDENTIALS');
        }
        const auth = Buffer.from(`${clientId}:${clientSecret}`).toString('base64');
        const response = await fetch(`${base}/v1/oauth2/token`, {
            method: 'POST',
            body: 'grant_type=client_credentials',
            headers: {
                Authorization: `Basic ${auth}`,
            },
        });

        const data = await response.json();
        return data.access_token;
    } catch (error) {
        console.error('Failed to generate Access Token:', error);
        throw new Error('Failed To generate Access Token');
    }
};
