const OfferRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const offerController = require('../controller/offer.controller');

module.exports = (app) => {
    OfferRouter.post('/', websiteImageUpload, offerController.create);

    // get all

    OfferRouter.get('/', offerController.getAll);

    // get active data

    OfferRouter.get('/active', offerController.getActiveData);

    // get one

    OfferRouter.get('/:id', offerController.getOne);

    // update

    OfferRouter.put('/:id', websiteImageUpload, offerController.update);

    // delete

    OfferRouter.delete('/:id', offerController.delete);

    app.use('/api/offer', OfferRouter);
};
