const metadtaRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const metadtaController = require('../controllers/metadata.controller');

module.exports = (app) => {
    metadtaRouter.post('/', websiteImageUpload, metadtaController.create);

    // get all

    metadtaRouter.get('/', metadtaController.getAll);

    // get active data

    metadtaRouter.get('/active', metadtaController.getActiveData);

    // update

    metadtaRouter.put('/:id', websiteImageUpload, metadtaController.update);

    // delete

    metadtaRouter.delete('/:id', metadtaController.delete);

    app.use('/api/metadata', metadtaRouter);
};
