module.exports = (sequelize, DataTypes) => {
    const events = sequelize.define(
        'events',
        {
            title: {
                type: DataTypes.STRING,
                allowNull: false,
            },
            event_cat: {
                type: DataTypes.STRING,
                allowNull: false,
            },
            date_type: {
                type: DataTypes.ENUM('single', 'daily', 'weekly', 'monthly'),
                allowNull: false,
            },
            event_date: {
                type: DataTypes.DATE,
                allowNull: false,
            },
            event_date_time: {
                type: DataTypes.STRING,
                allowNull: true,
            },

            event_img: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            location: {
                type: DataTypes.STRING,
                allowNull: true,
            },

            short_description: {
                type: DataTypes.TEXT,
                allowNull: true,
            },
            description: {
                type: DataTypes.TEXT,
                allowNull: true,
            },
            order: {
                type: DataTypes.INTEGER,
                allowNull: false,
            },
            status: {
                type: DataTypes.INTEGER,
                defaultValue: 1,
            },
        },
        {
            hooks: {
                async beforeValidate(event) {
                    if (!event.order) {
                        // Query to find the maximum order value
                        const maxOrder = await events.max('order');
                        // Set the next order value (maxOrder + 1), or 1 if no records exist
                        // eslint-disable-next-line no-param-reassign
                        event.order = (maxOrder || 0) + 1;
                    }
                },
            },
        }
    );

    return events;
};
