const courseCatRouter = require('express').Router();
const courseCatController = require('../controllers/courseCat.controller');

module.exports = (app) => {
    courseCatRouter.post('/', courseCatController.create);

    // get all

    courseCatRouter.get('/', courseCatController.getAll);

    // get one course with id

    courseCatRouter.get('/:id', courseCatController.getOne);

    // get active data

    courseCatRouter.get('/getData/active', courseCatController.getActiveData);

    // update

    courseCatRouter.put('/:id', courseCatController.update);

    // delete

    courseCatRouter.delete('/:id', courseCatController.delete);

    app.use('/api/course-category', courseCatRouter);
};
