const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const ContactUsModel = db.model.contact_us;

exports.create = async (req, res) => {
    try {
        const { name, phone, email, subject, message, status } = req.body;

        console.log(req.body);

        const result = await ContactUsModel.create({
            name,
            phone,
            email,
            subject,
            message,
            status,
        });
        // const result = await ContactUsModel.create({
        //     name: req.body?.name,
        //     phone: req.body?.phone,
        //     email: req.body?.email,
        //     subject: req.body?.subject,
        //     message: req.body?.message,
        //     status: req.body?.status,
        // });

        if (!result) {
            return errorResponse(404, 'FAILED', 'Failed to create contact us', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

exports.getAll = async (_, res) => {
    try {
        const result = await ContactUsModel.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await ContactUsModel.findOne({
            where: {
                id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO  data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await ContactUsModel.findOne({
            where: {
                status: 1,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;

        const isExist = await ContactUsModel.findByPk(id);

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No data found with this id', res);
        }

        const { location, email_address, phone_numbers, google_map_link, status } = req.body;

        const result = await ContactUsModel.update(
            {
                location,
                email_address,
                phone_numbers,
                google_map_link,
                status,
            },
            {
                where: {
                    id,
                },
            }
        );

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Failed to update new Banner', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete heroSection

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await ContactUsModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Contact Us modal deleted failed', res);
        }

        return successResponse(204, 'OK', 'Contact Us deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
