const { booking_status } = require('../constant/booking.constant');

module.exports = (sequelize, DataTypes) => {
    const Booking = sequelize.define('bookings', {
        date: {
            type: DataTypes.DATEONLY,
            allowNull: false,
        },
        name: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        phone: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        email: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        tour_id: {
            type: DataTypes.INTEGER,
            allowNull: false,
        },
        status: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
        },
        // status: {
        //     type: DataTypes.STRING,
        //     allowNull: false,
        //     defaultValue: booking_status.PENDING,
        // },
    });

    return Booking;
};
