const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');

const generateCodeAndToken = (mobile) => {
    const uniqueNumber = Math.floor(100000 + Math.random() * 900000).toString();
    console.log('unique number', uniqueNumber);
    const encryptedCode = bcrypt.hashSync(uniqueNumber, 10);

    // generate token

    const token = jwt.sign({ mobile, code: encryptedCode }, process.env.JWT_SECRET, {
        expiresIn: '1h',
    });
    return { token, code: uniqueNumber };
};

module.exports = { generateCodeAndToken };
