const aboutUsRoute = require('express').Router();

const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const aboutUsController = require('../controller/aboutUs.controller');

module.exports = (app) => {
    aboutUsRoute.post('', websiteImageUpload, aboutUsController.create);

    aboutUsRoute.get('/', aboutUsController.findAll);

    // get one data by id

    aboutUsRoute.get('/:id', aboutUsController.getOne);
    // find active about us data

    aboutUsRoute.get('/get-one/active', aboutUsController.findActive);

    // update about us section

    aboutUsRoute.put('/:id', websiteImageUpload, aboutUsController.update);

    // delete about us section

    aboutUsRoute.delete('/:id', aboutUsController.delete);

    app.use('/api/about-us', aboutUsRoute);
};
