module.exports = (sequelize, DataTypes) => {
    const User = sequelize.define('user', {
        role_id: {
            type: DataTypes.INTEGER,
        },
        registration_no: {
            type: DataTypes.STRING(20),
            allowNull: true,
        },

        f_name: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        l_name: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        date_of_birth: {
            type: DataTypes.DATEONLY,
            allowNull: true,
        },
        mobile: {
            type: DataTypes.STRING(15),
            allowNull: false,
        },
        password: {
            type: DataTypes.TEXT,
            allowNull: false,
        },
        email: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        address_1: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        address_2: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        image: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        finger_print: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        user_otp: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        contact_person: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        passport_no: {
            type: DataTypes.STRING,
            allowNull: true,
        },
        nid: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        credit_limit: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
            allowNull: true,
        },
        commission_rate: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
            allowNull: true,
        },
        remarks: {
            type: DataTypes.TEXT,
            allowNull: true,
        },
        wallet: {
            type: DataTypes.FLOAT,
            defaultValue: 0,
            allowNull: true,
        },
        status: {
            type: DataTypes.INTEGER,
            defaultValue: 1,
            comment: '1 = Active, 0 = Inactive',
        },
        created_by: {
            type: DataTypes.INTEGER,
            comment: 'User ID',
            defaultValue: 0,
        },
        updated_by: {
            type: DataTypes.INTEGER,
            comment: 'User ID',
            defaultValue: 0,
        },
    });

    User.beforeCreate(async (user) => {
        try {
            if (user.registration_no === null || user.registration_no === undefined) {
                const maxRegistrationNo = await User.max('registration_no');
                // eslint-disable-next-line no-param-reassign
                user.registration_no =
                    (maxRegistrationNo !== null ? parseInt(maxRegistrationNo, 10) : 1000000000001) +
                    1;
            }
        } catch (err) {
            console.error('Error setting values:', err);
            throw new Error(err);
        }
    });

    return User;
};
