const db = require('../../../../config/database.config');

module.exports = (sequelize, DataTypes) => {
    const menuItems = sequelize.define(
        'menu_items',
        {
            menu_level: {
                type: DataTypes.STRING,
                allowNull: false, // This field is required
            },
            menu_group_id: {
                type: DataTypes.INTEGER,
                allowNull: false, // This field is required
            },
            url_slug: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            menu_order: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            menu_icon: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            parent_menu_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            status: {
                type: DataTypes.INTEGER,
            },
        },
        {
            freezeTableName: true,
        }
    );

    return menuItems;
};
