const menuGroupRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const menuGroupController = require('../controllers/menuGroup.controller');

module.exports = (app) => {
    // Create a new menu group
    menuGroupRouter.post('/', websiteImageUpload, menuGroupController.create);

    // get all the menu groups

    menuGroupRouter.get('/', menuGroupController.findAll);

    // get all active the menu groups

    menuGroupRouter.get('/active/', menuGroupController.findActive);

    // get one active menu with active menu items
    menuGroupRouter.get('/active/menu-item/website', menuGroupController.findActiveMenuForWeb);

    //  update menu groups

    menuGroupRouter.put('/:id', websiteImageUpload, menuGroupController.update);

    // delete single menu group with id

    menuGroupRouter.delete('/:id', menuGroupController.delete);

    app.use('/api/menu-group', menuGroupRouter);
};
