const multer = require('multer');
const path = require('path');

const uploadFolder = path.join(__dirname, '../uploads/website/');
const allowedExtensions = ['.jpg', '.jpeg', '.png', '.webp'];

const storage = multer.diskStorage({
    destination(req, res, cb) {
        cb(null, uploadFolder);
    },
    filename(req, file, cb) {
        console.log(file);
        const fileExt = path.extname(file.originalname);
        let fileName = file.originalname.replace(fileExt, '').toLowerCase().split(' ').join('-');

        if (fileName.length > 21) {
            fileName = fileName.slice(1, 20);
        }

        fileName += `-${Date.now()}`;
        cb(null, fileName + fileExt);
    },
});

const fileFilter = (req, file, cb) => {
    const extname = path.extname(file.originalname).toLowerCase();
    if (allowedExtensions.includes(extname)) {
        cb(null, true);
    } else {
        cb(new Error('Unsupported file type'), false);
    }
};

const upload = multer({
    storage,
    fileFilter,
});

module.exports = upload.any();
