const jwt = require('jsonwebtoken');
require('dotenv').config();
const db = require('../config/database.config');
// const db = require('../config/database.config');
const errorResponse = require('../utils/errorResponse');

const UserModel = db.model.user;
const verifyToken = async (req, res, next) => {
    try {
        const authBearerToken = req?.headers?.authorization;
        // console.log(`authBearerToken:`, authBearerToken);

        // verifyToken

        const token = authBearerToken && authBearerToken.split(' ')[1];

        if (!token) {
            return next();
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        // Fetch user from database
        const user = await UserModel.findOne({
            where: {
                mobile: decoded.mobile,
            },
        });

        req.user = user;
        return next();
    } catch (error) {
        console.log(error);
        return next();
    }
};

const verifyUser = async (req, res, next) => {
    try {
        const authBearerToken = req?.headers?.authorization;
        // console.log(`authBearerToken:`, authBearerToken);

        if (!authBearerToken) {
            return errorResponse(403, 'Forbidden Access', 'Token Not Found', res);
        }
        // verifyToken

        const token = authBearerToken.split(' ')[1];
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        console.log(`decoded:`, decoded);

        if (!decoded) {
            return errorResponse(403, 'Forbidden Access', 'Invalid Token', res);
        }

        // Fetch user from database
        const user = await UserModel.findOne({
            where: {
                mobile: decoded.mobile,
            },
        });
        if (!user) {
            return errorResponse(403, 'Forbidden Access', 'User Not Found', res);
        }
        req.user = user.dataValues;
        return next();
    } catch (error) {
        return errorResponse(
            500,
            'ERROR',
            error.message || 'Some error occurred while Verifying Token',
            res
        );
    }
};

module.exports = {
    verifyToken,
    verifyUser,
};
