/* eslint-disable prettier/prettier */
require("dotenv").config();
const { Sequelize, DataTypes } = require("sequelize");

const sequelize = new Sequelize(
  process.env.DB_DATABASE,
  process.env.DB_USER,
  process.env.DB_PASSWORD,
  {
    host: process.env.DB_HOST,
    dialect: "mysql",
    // logging: false,

    pool: {
      max: 5,
      min: 0,
      acquire: 30000,
      idle: 10000,
    },
  }
);

const db = {};
db.DataTypes = DataTypes;
db.sequelize = sequelize;
db.Sequelize = Sequelize;

// db.model = require("../config/model.config.js")(sequelize, DataTypes);
db.model = require("./model.config")(sequelize, DataTypes);

module.exports = db;
